AnimatedText = copy_table(Text)

-- list of handled parameters and their defaults
AnimatedText.defaults = {
    shift_x = 0,
    shift_y = 0,
    alpha = 1,
    additive = false,
}


function AnimatedText:init(def, view)
    Text.init(self, def, view)
    
    self.additive = def.additive or false

    local ani = Animator:new()

    for var, default in pairs(self.defaults) do
        if def[var] then
            if type(def[var]) == "table" then
                for i = 2, #def[var] do
                    ani:add_key(var, def[var][i][1], def[var][i][2])
                end
            else
                ani:add_key(var, 0, tonumber(def[var]))
            end
        else
            ani:add_key(var, 0, default)
        end
    end

    self.animator = ani
end


function AnimatedText:destroy()
    Text.destroy(self)
end

function AnimatedText:restart()
    self.animator:restart()
end

function AnimatedText:update(dt)
    self.animator:update(dt)
end

function AnimatedText:render()
    if self.additive then gfx_blending("add") end
    gfx_render_text(self.font, self.x + self.animator.val.shift_x, self.y + self.animator.val.shift_y, self.text, self.align, self.w, self.h, self.animator.val.alpha, self.color)
    if self.additive then gfx_blending() end
end
